/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.BoundingRechteck;
import ea.EngineAlpha;
import ea.Farbe;
import ea.Knoten;
import ea.Punkt;
import ea.Raum;
import ea.Vektor;
import ea.internal.gra.Zeichenebene;
import ea.internal.util.Logger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class Kamera {
    private Zeichenebene ebene;
    private BoundingRechteck bild;
    private BoundingRechteck bounds;
    private Raum fokus = null;
    private Vektor verzug = Vektor.NULLVEKTOR;
    private boolean hatBounds = false;

    public Kamera(int sizeX, int sizeY, Zeichenebene z) {
        this.ebene = z;
        this.bild = new BoundingRechteck(0.0f, 0.0f, sizeX, sizeY);
    }

    public void fokusSetzen(Raum r) {
        this.setzeFokus(r);
    }

    public void setzeFokus(Raum r) {
        this.fokus = r;
    }

    public void fokusVerzugSetzen(Vektor v) {
        this.verzug = v;
    }

    public void boundsSetzen(BoundingRechteck r) {
        if (r == null) {
            Logger.error("Der Eingabewert fuer den Fokusbereich war null!");
            return;
        }
        this.hatBoundsSetzen(true);
        this.bounds = r;
    }

    public void hatBoundsSetzen(boolean b) {
        this.hatBounds = b;
    }

    public void fokusLoeschen() {
        this.loescheFokus();
    }

    public void loescheFokus() {
        this.fokus = null;
    }

    public void verschieben(int x, int y) {
        this.verschieben(new Vektor(x, y));
    }

    public void verschieben(Vektor v) {
        this.bild = this.bild.verschobeneInstanz(v);
    }

    public void zentrumSetzen(int x, int y) {
        this.zentrumSetzen(new Punkt(x, y));
    }

    public void zentrumSetzen(Punkt zentrum) {
        this.bild = this.bild.mittenAngleichInstanz(zentrum);
    }

    public void positionSetzen(Punkt p) {
        this.positionSetzen(p.x, p.y);
    }

    public void positionSetzen(float x, float y) {
        this.bild = this.bild.anPosition(x, y);
    }

    public Knoten wurzel() {
        return this.ebene.basis();
    }

    public BoundingRechteck position() {
        return this.bild;
    }

    public int getX() {
        return (int)this.bild.x;
    }

    public int getY() {
        return (int)this.bild.y;
    }

    public void zeichne(Graphics2D g) {
        if (this.hatFokus()) {
            this.bild = this.bild.mittenAngleichInstanz(this.fokus.dimension());
            this.bild = this.bild.verschobeneInstanz(this.verzug);
        }
        if (this.hatBounds) {
            this.bild = this.bild.in(this.bounds);
        }
        this.ebene.basis().zeichnen(g, this.bild);
        if (EngineAlpha.isDebug()) {
            int tx = (int)this.bild.x;
            int ty = (int)this.bild.y;
            int gridSize = 50;
            g.translate(-tx, -ty);
            g.setFont(new Font("SansSerif", 0, 10));
            g.setColor(new Color(255, 255, 255, 100));
            int x = tx / gridSize * gridSize;
            while ((float)x < (float)tx + this.bild.breite) {
                g.drawLine(x, ty, x, ty + (int)this.bild.hoehe);
                g.drawString("" + x, x + 10, ty + 20);
                x += gridSize;
            }
            int y = ty / gridSize * gridSize;
            while ((float)y < (float)ty + this.bild.hoehe) {
                g.drawLine(tx, y, tx + (int)this.bild.breite, y);
                g.drawString("" + y, tx + 10, y + 20);
                y += gridSize;
            }
            g.translate(tx, ty);
            Raum debugBoxes = this.ebene.basis().aktuellerCollider().visualize(this.ebene.basis().position(), new Farbe(255, 255, 255, 20));
            debugBoxes.zeichnen(g, this.bild);
        }
    }

    public boolean hatFokus() {
        return this.fokus != null;
    }
}

