/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.AnimationsManager;
import ea.Bild;
import ea.BoundingRechteck;
import ea.DateiManager;
import ea.Farbe;
import ea.Kamera;
import ea.Knoten;
import ea.KollisionsReagierbar;
import ea.Manager;
import ea.Maus;
import ea.Raum;
import ea.Rechteck;
import ea.TastenLosgelassenReagierbar;
import ea.TastenReagierbar;
import ea.Text;
import ea.Ticker;
import ea.internal.gui.Eingabe;
import ea.internal.gui.Fenster;
import ea.internal.gui.Frage;
import ea.internal.gui.HighScoreFenster;
import ea.internal.gui.Nachricht;
import ea.internal.phy.Physik;
import ea.internal.util.Logger;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class Game
implements TastenReagierbar {
    public final Manager manager = new Manager();
    public final AnimationsManager animationsManager = AnimationsManager.getAnimationsManager();
    public final Knoten wurzel;
    public final Knoten statischeWurzel;
    public final Kamera cam;
    public final String pfadtrenner = DateiManager.sep;
    private final Fenster fenster;
    private final Knoten superWurzel;
    private final boolean exitOnEsc;
    private final Random zufall = new Random();
    private final Rechteck blende;
    private Font font;

    public Game(int x, int y, boolean vollbild) {
        this(x, y, "", vollbild, true);
    }

    public Game(int x, int y, String titel, boolean vollbild, boolean exitOnEsc) {
        this(x, y, titel, vollbild, exitOnEsc, -1, -1);
    }

    public Game(int x, int y, String titel, boolean vollbild, boolean exitOnEsc, int fensterX, int fensterY) {
        this.fenster = new Fenster(x, y, titel, vollbild, fensterX, fensterY);
        this.exitOnEsc = exitOnEsc;
        this.cam = this.fenster.getCam();
        Raum[] raumArray = new Raum[2];
        this.wurzel = new Knoten();
        raumArray[0] = this.wurzel;
        this.superWurzel = new Knoten();
        raumArray[1] = this.superWurzel;
        this.cam.wurzel().add(raumArray);
        this.blende = this.fenster.fenstermasse().ausDiesem();
        this.blende.farbeSetzen(new Farbe(255, 255, 255, 190));
        this.blende.sichtbarSetzen(false);
        this.statischeWurzel = this.fenster.getStatNode();
        this.statischeWurzel.add((Raum)this.blende);
        this.fenster.anmelden(this);
        try {
            this.fenster.setIconImage(ImageIO.read(this.getClass().getResourceAsStream("/assets/favicon.png")));
        }
        catch (Exception e) {
            Logger.warning("Standard-Icon konnte nicht geladen werden.");
        }
    }

    public Game(int x, int y) {
        this(x, y, "");
    }

    public Game(int x, int y, String titel) {
        this(x, y, titel, false, true);
    }

    public Game() {
        this(500, 500, "", false);
    }

    public Game(int x, int y, String titel, boolean vollbild) {
        this(x, y, titel, vollbild, true);
    }

    public void iconSetzen(Bild icon) {
        this.fenster.setIconImage(icon.bild());
    }

    @Override
    public void reagieren(int code) {
        if (this.exitOnEsc && code == 32) {
            this.beenden();
        }
        this.tasteReagieren(code);
    }

    public void beenden() {
        this.fenster.loeschen();
    }

    public abstract void tasteReagieren(int var1);

    public String eingabeFordern(String nachricht) {
        new Eingabe((Frame)this.fenster, nachricht, this.font);
        return Eingabe.ergebnis;
    }

    public boolean sicherheitsFrage(String frage) {
        new Frage((Frame)this.fenster, frage, false, this.font);
        return Frage.ergebnis;
    }

    public boolean frage(String frage) {
        new Frage((Frame)this.fenster, frage, true, this.font);
        return Frage.ergebnis;
    }

    public void nachrichtSchicken(String nachricht) {
        new Nachricht((Frame)this.fenster, true, nachricht, this.font);
    }

    public void highscoreAnzeigen(String[] namen, int[] punkte) {
        this.highscoreAnzeigen(namen, punkte, "");
    }

    public void highscoreAnzeigen(String[] namen, int[] punkte, String fenstertitel) {
        new HighScoreFenster(this.fenster, fenstertitel, namen, punkte, this.font);
    }

    public boolean zufallsBoolean() {
        return this.zufall.nextBoolean();
    }

    public int zufallsZahl(int obergrenze) {
        if (obergrenze < 0) {
            throw new IllegalArgumentException("Achtung! F\u00fcr eine Zufallszahl muss die definierte Obergrenze (die inklusiv in der Ergebnismenge ist) eine nichtnegative Zahl sein!");
        }
        return this.zufall.nextInt(obergrenze + 1);
    }

    public void schliessen() {
        this.manager.kill();
        this.fenster.loeschen();
    }

    public void warten(int millisekunden) {
        try {
            Thread.sleep(millisekunden);
        }
        catch (InterruptedException e) {
            Logger.error(e.getLocalizedMessage());
        }
    }

    public void fensterFontSetzen(String fontname) {
        this.fensterFontSetzen(fontname, 12);
    }

    public void fensterFontSetzen(String fontname, int schriftgroesse) {
        this.font = Text.holeFont(fontname).deriveFont(0, schriftgroesse);
    }

    public void fensterMinimieren() {
        this.fenster.minimieren();
    }

    public void fensterMaximieren() {
        this.fenster.maximieren();
    }

    public void tastenReagierbarAnmelden(TastenReagierbar g) {
        if (g instanceof Game) {
            Logger.error("Der Eingabe-Parameter g leitet sich von der Klasse Game ab. Das w\u00fcrde f\u00fcr einen internen Fehler sorgen und ist daher nicht m\u00f6glich. Stattdessen kann man die tasteReagieren-Methode verwenden oder \u00fcber eine andere mit diesem Interface den selben Effekt erzeugen.");
            return;
        }
        this.fenster.anmelden(g);
    }

    public boolean tasteGedrueckt(int code) {
        return this.fenster.istGedrueckt(code);
    }

    public void tastenLosgelassenReagierbarAnmelden(TastenLosgelassenReagierbar g) {
        this.fenster.tastenLosgelassenAnmelden(g);
    }

    public void tickerAnmelden(Ticker ticker, int intervall) {
        this.manager.anmelden(ticker, intervall);
    }

    public void tickerAbmelden(Ticker ticker) {
        this.manager.abmelden(ticker);
    }

    public void kollisionsReagierbarAnmelden(KollisionsReagierbar reagierbar, Raum r1, Raum r2, int code) {
        Physik.getPhysik().anmelden(reagierbar, r1, r2, code);
    }

    public void mausAnmelden(Maus maus) {
        this.mausAnmelden(maus, false);
    }

    public void mausAnmelden(Maus maus, boolean listenerUebernehmen) {
        if (maus == null) {
            Logger.error("Die anzumeldende Maus war ein nicht instanziertes Objekt (sprich: null)!");
            return;
        }
        Maus alteMaus = this.fenster.getMaus();
        this.fenster.mausLoeschen();
        if (alteMaus != null && listenerUebernehmen) {
            maus.uebernehmeAlleListener(alteMaus);
        }
        this.fenster.anmelden(maus);
    }

    public BoundingRechteck fensterGroesse() {
        return this.fenster.fenstermasse();
    }

    public void hintergrundSetzen(Raum m) {
        this.fenster.hintergrundAnmelden(m);
    }

    public void ueberblendeSetzen(boolean aktiv, Farbe farbe) {
        if (farbe.undurchsichtig()) {
            farbe = farbe.halbesAlpha();
        }
        this.blende.farbeSetzen(farbe);
        this.ueberblendeSetzen(aktiv);
    }

    public void ueberblendeSetzen(boolean aktiv) {
        this.blende.sichtbarSetzen(aktiv);
    }

    public void rechenintensiveArbeitSetzen(boolean rechenintensiv) {
        Raum.heavyComputingSetzen(rechenintensiv);
    }

    public void screenshot(String pfad) {
        this.screenshot(pfad, this.cam.position());
    }

    public void screenshot(final String pfad, final BoundingRechteck ausschnitt) {
        final String ext = pfad.toLowerCase().substring(pfad.length() - 3);
        if (!ext.equals("png") && !ext.equals("jpg")) {
            throw new IllegalArgumentException("Pfad muss auf .jpg oder .png enden!");
        }
        new Thread(){

            @Override
            public void run() {
                BufferedImage img = new BufferedImage((int)ausschnitt.breite, (int)ausschnitt.hoehe, 1);
                Graphics2D g = img.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                Game.this.cam.wurzel().zeichnen(g, ausschnitt);
                try {
                    ImageIO.write((RenderedImage)img, ext, new File(pfad));
                }
                catch (IOException e) {
                    Logger.error("Schreibfehler beim Speichern des Screenshots!");
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void screenshot(String pfad, int x, int y, int breite, int hoehe) {
        this.screenshot(pfad, new BoundingRechteck(x, y, breite, hoehe));
    }

    public String pfadAuswaehlen(final String ... akzeptierteEndungen) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (akzeptierteEndungen == null) {
                    return true;
                }
                if (pathname.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < akzeptierteEndungen.length; ++i) {
                    if (!pathname.getName().toLowerCase().endsWith("." + akzeptierteEndungen[i].toLowerCase())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                if (akzeptierteEndungen == null) {
                    return "Alle Dateien w\u00e4hlbar";
                }
                String sel = "";
                for (int i = 0; i < akzeptierteEndungen.length; ++i) {
                    sel = sel + "." + akzeptierteEndungen[i].toLowerCase() + " ";
                }
                return "Ausgew\u00e4hlte Formate (" + sel + ")";
            }
        };
        JFileChooser ch = new JFileChooser();
        ch.setFileFilter(filter);
        int erg = ch.showOpenDialog(this.fenster);
        if (erg == 0) {
            return ch.getSelectedFile().getPath();
        }
        return null;
    }

    public boolean kopieren(String von, String nach, String nameNeu) {
        try {
            Files.copy(Paths.get(von, new String[0]), Paths.get(nach, nameNeu), new CopyOption[0]);
        }
        catch (FileNotFoundException e) {
            Logger.error("Die Datei konnte nicht gefunden werden!");
            return false;
        }
        catch (IOException e) {
            Logger.error("Fehler beim Lesen!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static {
        System.setProperty("sun.java2d.opengl", "true");
        System.setProperty("sun.java2d.d3d", "false");
        System.setProperty("sun.java2d.noddraw", "true");
        System.setProperty("sun.java2d.pmoffscreen", "false");
        System.setProperty("sun.java2d.ddoffscreen", "true");
        System.setProperty("sun.java2d.ddscale", "true");
    }
}

