/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.API;
import ea.BoundingRechteck;
import ea.DateiManager;
import ea.Farbe;
import ea.Manager;
import ea.NoExternalUse;
import ea.Punkt;
import ea.Raum;
import ea.Ticker;
import ea.Vektor;
import ea.internal.collision.BoxCollider;
import ea.internal.collision.Collider;
import ea.internal.collision.ColliderGroup;
import ea.internal.gra.PixelFeld;
import ea.internal.util.Logger;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;

public class Figur
extends Raum {
    private static final long serialVersionUID = -1063599158092163887L;
    private static ArrayList<Figur> liste = new ArrayList();
    protected PixelFeld[] animation;
    private int intervall = 100;
    private int aktuelle = 0;
    private boolean laeuft;
    private boolean spiegelX = false;
    private boolean spiegelY = false;

    public Figur(String verzeichnis) {
        this(0.0f, 0.0f, verzeichnis);
    }

    public Figur(float x, float y, String verzeichnis) {
        this(x, y, verzeichnis, true);
    }

    public Figur(float x, float y, String verzeichnis, boolean add) {
        this.position = new Punkt(x, y);
        this.animation = DateiManager.figurEinlesen((String)verzeichnis).animation;
        if (add) {
            liste.add(this);
        }
        this.laeuft = true;
    }

    public Figur() {
        liste.add(this);
    }

    @API
    public void animationLoeschen(int index) {
        if (this.animation.length < 2) {
            throw new RuntimeException("Es muss mindestens ein Pixelfeld erhalten bleiben! Eine weitere L\u00f6schung h\u00e4tte das letzte Element entfernt.");
        }
        PixelFeld[] neu = new PixelFeld[this.animation.length - 1];
        System.arraycopy(this.animation, 0, neu, 0, index);
        System.arraycopy(this.animation, index + 1, neu, index, neu.length - index);
        this.aktuelle = 0;
        this.animation = neu;
    }

    @NoExternalUse
    public void animationsBildSetzen(PixelFeld bild, int index) {
        if (bild == null) {
            throw new IllegalArgumentException("Parameter bild darf nicht null sein!");
        }
        this.animation[index] = bild;
    }

    @API
    public void animationsBildVerschieben(int indexAlt, int indexNeu) {
        if (indexAlt == indexNeu) {
            return;
        }
        PixelFeld bild = this.animation[indexAlt];
        if (indexAlt > indexNeu) {
            System.arraycopy(this.animation, indexNeu + 1, this.animation, indexNeu, indexAlt - indexNeu);
        } else {
            System.arraycopy(this.animation, indexAlt, this.animation, indexAlt - 1, indexNeu - indexAlt);
        }
        this.animation[indexNeu] = bild;
    }

    @NoExternalUse
    public void animationsSchritt(int runde) {
        if (runde % this.intervall != 0) {
            return;
        }
        this.aktuelle = this.aktuelle == this.animation.length - 1 ? 0 : ++this.aktuelle;
    }

    public void animationSetzen(PixelFeld[] a) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter a darf nicht null sein!");
        }
        if (a.length < 1) {
            throw new IllegalArgumentException("Parameter a muss mindestens die L\u00e4nge 1 haben.");
        }
        this.animation = a;
        this.aktuelle = 0;
    }

    public void animiertSetzen(boolean animiert) {
        this.laeuft = animiert;
    }

    public boolean animiert() {
        return this.laeuft;
    }

    public void animationsBildSetzen(int bildIndex) {
        if (bildIndex < 0 || bildIndex >= this.animation.length) {
            Logger.error("Achtung! Der zu setzende Bildindex war gr\u00f6\u00dfer als der gr\u00f6\u00dfte vorhandene Index oder kleiner 0! Daher wird nichts gesetzt.");
            return;
        }
        this.aktuelle = bildIndex;
    }

    public void faktorSetzen(int faktor) {
        for (int i = 0; i < this.animation.length; ++i) {
            this.animation[i].faktorSetzen(faktor);
        }
    }

    public void negativ() {
        for (int i = 0; i < this.animation.length; ++i) {
            this.animation[i].negativ();
        }
    }

    public void heller() {
        for (int i = 0; i < this.animation.length; ++i) {
            this.animation[i].heller();
        }
    }

    public void dunkler() {
        for (int i = 0; i < this.animation.length; ++i) {
            this.animation[i].dunkler();
        }
    }

    public void farbenTransformieren(int r, int g, int b) {
        for (int i = 0; i < this.animation.length; ++i) {
            this.animation[i].transformieren(r, g, b);
        }
    }

    public void einfaerben(String farbe) {
        this.einfaerben(Farbe.vonString(farbe));
    }

    public void einfaerben(Farbe f) {
        for (int i = 0; i < this.animation.length; ++i) {
            this.animation[i].einfaerben(f.wert());
        }
    }

    public void spiegelXSetzen(boolean spiegel) {
        this.spiegelX = spiegel;
    }

    public void spiegelYSetzen(boolean spiegel) {
        this.spiegelY = spiegel;
    }

    public boolean xGespiegelt() {
        return this.spiegelX;
    }

    public boolean yGespiegelt() {
        return this.spiegelY;
    }

    public void zurueckFaerben() {
        for (int i = 0; i < this.animation.length; ++i) {
            this.animation[i].zurueckFaerben();
        }
    }

    void entfernen() {
        liste.remove(this);
    }

    @Override
    public void zeichnen(Graphics2D g, BoundingRechteck r) {
        if (r.schneidetBasic(this.dimension())) {
            super.beforeRender(g, r);
            this.animation[this.aktuelle].zeichnen(g, (int)(this.position.x - r.x), (int)(this.position.y - r.y), this.spiegelX, this.spiegelY);
            super.afterRender(g, r);
        }
    }

    @Override
    public BoundingRechteck dimension() {
        if (this.animation != null && this.animation[this.aktuelle] != null) {
            return new BoundingRechteck(this.position.x, this.position.y, this.animation[0].breite(), this.animation[0].hoehe());
        }
        return new BoundingRechteck(this.position.x, this.position.y, this.animation[this.aktuelle].breite(), this.animation[this.aktuelle].hoehe());
    }

    @Override
    public Collider erzeugeCollider() {
        ColliderGroup cg = new ColliderGroup();
        for (BoundingRechteck r : this.flaechen()) {
            cg.addCollider(BoxCollider.fromBoundingRechteck(new Vektor(r.x - this.position.x, r.y - this.position.y), r));
        }
        return cg;
    }

    @Override
    public BoundingRechteck[] flaechen() {
        return this.animation[this.aktuelle].flaechen(this.position.x, this.position.y);
    }

    public int aktuellesBild() {
        return this.aktuelle;
    }

    public PixelFeld[] animation() {
        return this.animation;
    }

    public int intervall() {
        return this.intervall;
    }

    public void animationsGeschwindigkeitSetzen(int intervall) {
        this.intervall = intervall;
    }

    static {
        Manager.standard.anmelden(new Ticker(){
            int runde = 0;

            @Override
            public void tick() {
                ++this.runde;
                try {
                    for (Figur f : liste) {
                        if (!f.animiert()) continue;
                        f.animationsSchritt(this.runde);
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }, 1);
    }
}

