/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.BoundingRechteck;
import ea.Geometrie;
import ea.Punkt;
import ea.Vektor;
import ea.internal.collision.Collider;
import ea.internal.util.Logger;
import java.awt.Color;
import java.awt.Graphics2D;

public class Dreieck
extends Geometrie {
    private float[] x = new float[3];
    private float[] y = new float[3];
    private Color farbe = Color.white;

    public Dreieck(Punkt p1, Punkt p2, Punkt p3) {
        super(0.0f, 0.0f);
        this.x[0] = p1.x;
        this.x[1] = p2.x;
        this.x[2] = p3.x;
        this.y[0] = p1.y;
        this.y[1] = p2.y;
        this.y[2] = p3.y;
        this.aktualisierenFirst();
    }

    public Dreieck(float[] x, float[] y) {
        super(0.0f, 0.0f);
        if (x.length == 3 && y.length == 3) {
            this.x = x;
            this.y = y;
        } else {
            Logger.error("L\u00e4uft nicht, falsche Arrayl\u00e4ngen bei Dreiecksbildung!");
        }
    }

    public Color getColor() {
        return this.farbe;
    }

    public void setColor(Color c) {
        this.farbe = c;
    }

    public void punkteSetzen(Punkt p1, Punkt p2, Punkt p3) {
        this.x[0] = p1.x;
        this.x[1] = p2.x;
        this.x[2] = p3.x;
        this.y[0] = p1.y;
        this.y[1] = p2.y;
        this.y[2] = p3.y;
    }

    public void punkteSetzen(float[] x, float[] y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void zeichnen(Graphics2D g, BoundingRechteck r) {
        if (!r.schneidetBasic(this.dimension())) {
            return;
        }
        super.beforeRender(g, r);
        int[] x = new int[]{(int)this.x[0], (int)this.x[1], (int)this.x[2]};
        int[] y = new int[]{(int)this.y[0], (int)this.y[1], (int)this.y[2]};
        int i = 0;
        while (i < 3) {
            int n = i;
            x[n] = (int)((float)x[n] - r.x);
            int n2 = i++;
            y[n2] = (int)((float)y[n2] - r.y);
        }
        g.setColor(this.farbe);
        g.fillPolygon(x, y, 3);
        super.afterRender(g, r);
    }

    @Override
    public BoundingRechteck dimension() {
        float kleinstesX = this.x[0];
        float groesstesX = this.x[0];
        float kleinstesY = this.y[0];
        float groesstesY = this.y[0];
        for (int i = 0; i < 3; ++i) {
            if (this.x[i] > groesstesX) {
                groesstesX = this.x[i];
            }
            if (this.x[i] < kleinstesX) {
                kleinstesX = this.x[i];
            }
            if (this.y[i] > groesstesY) {
                groesstesY = this.y[i];
            }
            if (!(this.y[i] < kleinstesY)) continue;
            kleinstesY = this.y[i];
        }
        return new BoundingRechteck(kleinstesX, kleinstesY, groesstesX - kleinstesX, groesstesY - kleinstesY);
    }

    @Override
    public void verschieben(Vektor v) {
        int i = 0;
        while (i < 3) {
            int n = i;
            this.x[n] = this.x[n] + v.x;
            int n2 = i++;
            this.y[n2] = this.y[n2] + v.y;
        }
    }

    @Override
    public Collider erzeugeCollider() {
        return this.erzeugeLazyCollider();
    }

    @Override
    public Dreieck[] neuBerechnen() {
        Dreieck[] e = new Dreieck[]{this};
        return e;
    }

    public boolean schneidetBasic(Dreieck d) {
        return false;
    }

    public boolean schneidetBasic(BoundingRechteck r) {
        return r.schneidet(this);
    }

    public Punkt[] punkte() {
        Punkt[] ret = new Punkt[3];
        for (int i = 0; i < 3; ++i) {
            ret[i] = new Punkt(this.x[i], this.y[i]);
        }
        return ret;
    }
}

