/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.ActionFigur;
import ea.BoundingRechteck;
import ea.Raum;
import ea.Vektor;
import ea.internal.collision.Collider;
import ea.internal.collision.ColliderGroup;
import ea.internal.util.Logger;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class CombiFigur
extends Raum {
    private volatile ActionFigur[] figuren;
    private String[] namen;

    public CombiFigur(ActionFigur figur1, String name1) {
        this.figuren = new ActionFigur[]{figur1};
        this.namen = new String[]{name1};
    }

    public void add(ActionFigur figur, String name) {
        String[] namenNeu = new String[this.namen.length + 1];
        ActionFigur[] figurenNeu = new ActionFigur[this.figuren.length + 1];
        for (int i = 0; i < this.namen.length; ++i) {
            namenNeu[i] = this.namen[i];
            figurenNeu[i] = this.figuren[i];
        }
        namenNeu[namenNeu.length - 1] = name;
        figurenNeu[figurenNeu.length - 1] = figur;
    }

    public ActionFigur get(String name) {
        for (int i = 0; i < this.namen.length; ++i) {
            if (!this.namen[i].equals(name)) continue;
            return this.figuren[i];
        }
        Logger.error("Achtung! Der Eingegebene Name eines Gliedes dieser CombiFigur existiert nicht: " + name);
        return null;
    }

    @Override
    public void zeichnen(Graphics2D g, BoundingRechteck r) {
        super.beforeRender(g, r);
        for (int i = 0; i < this.figuren.length; ++i) {
            this.figuren[i].zeichnen(g, r);
        }
        super.afterRender(g, r);
    }

    @Override
    public BoundingRechteck dimension() {
        BoundingRechteck dim = this.figuren[0].dimension();
        for (ActionFigur f : this.figuren) {
            dim = dim.summe(f.dimension());
        }
        return dim;
    }

    @Override
    public void verschieben(Vektor v) {
        for (int i = 0; i < this.figuren.length; ++i) {
            this.figuren[i].verschieben(v);
        }
    }

    @Override
    public Collider erzeugeCollider() {
        ColliderGroup cg = new ColliderGroup();
        for (ActionFigur f : this.figuren) {
            cg.addCollider(f.erzeugeCollider());
        }
        return this.erzeugeLazyCollider();
    }

    @Override
    public BoundingRechteck[] flaechen() {
        ArrayList<BoundingRechteck> list = new ArrayList<BoundingRechteck>();
        for (ActionFigur f : this.figuren) {
            list.add(f.dimension());
        }
        return list.toArray(new BoundingRechteck[list.size()]);
    }
}

