/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Tracker {
    private static final String SESSION = UUID.randomUUID().toString();
    private static final String TRACKER_URL = "https://europe-west1-yo-tracking.cloudfunctions.net/onEvent";

    public static void sendEventAsync(Map<String, String> additionalParams) {
        new Thread(() -> {
            try {
                Tracker.sendEvent(additionalParams);
            }
            catch (IOException e) {
                System.err.println("sendEvent failed with IOException: " + e.getLocalizedMessage());
            }
        }).start();
    }

    private static void sendEvent(Map<String, String> additionalParams) throws IOException {
        String inputLine;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("session", SESSION);
        data.put("username", System.getProperty("user.name"));
        data.put("hostname", Tracker.hostname());
        if (additionalParams != null) {
            data.putAll(additionalParams);
        }
        URL url = new URL(TRACKER_URL);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        DataOutputStream out = new DataOutputStream(con.getOutputStream());
        out.writeBytes(ParameterStringBuilder.getParamsString(data));
        out.flush();
        out.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
    }

    private static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "unknown";
        }
    }
}

