/*
 * Decompiled with CFR 0.152.
 */
import ea.Sound;

public class SoundController {
    private String mainPath = "./Assets/Audio/";
    private Sound sadMusic = new Sound(this.mainPath + "sad.mp3");
    private Sound happyMusic = new Sound(this.mainPath + "happy.mp3");
    private Sound title1;
    private Sound title2;
    private Sound lysander = new Sound(this.mainPath + "lysander.mp3");
    private Sound itemFound;
    private Sound doorSound;
    private final int pauseLength = 12000;
    private int tickCounter = 3000;
    private boolean mute = false;

    public SoundController() {
        this.title1 = new Sound(this.mainPath + "title1.mp3");
        this.title2 = new Sound(this.mainPath + "title2.mp3");
        this.doorSound = new Sound(this.mainPath + "door.wav");
        this.itemFound = new Sound(this.mainPath + "itemFound.wav");
    }

    public void tickMusic() {
        ++this.tickCounter;
        if (this.tickCounter >= 12000) {
            this.tickCounter = 0;
            System.out.println("SoundController: Neue Music wird angefangen!");
            this.stopAllMusic();
            this.playRandomSound();
        }
    }

    public void toggleMute() {
        if (this.mute) {
            this.mute = false;
            System.out.println("SoundController: Game wurde entmutet");
            this.playRandomSound();
        } else {
            System.out.println("SoundController: Game wurde gemutet");
            this.mute = true;
            this.stopAllMusic();
        }
    }

    public void startTitleMusic() {
        double r = Math.random();
        if (r >= 0.5) {
            this.title1.play();
        } else {
            this.title2.play();
        }
    }

    public void playDoorSound() {
        if (!this.mute) {
            this.doorSound.play();
        }
    }

    public void playRandomSound() {
        if (!this.mute) {
            double r = Math.random();
            if (r >= 0.5) {
                this.lysander.play();
            } else {
                this.lysander.play();
            }
        }
    }

    public void playSadMusic() {
        if (!this.mute) {
            this.sadMusic.play();
        }
    }

    public void playHappyMusic() {
        if (!this.mute) {
            this.happyMusic.play();
        }
    }

    public void playItemFoundSound() {
        if (!this.mute) {
            this.itemFound.play();
        }
    }

    public void stopAllMusic() {
        this.sadMusic.stop();
        this.happyMusic.stop();
        this.lysander.stop();
        this.title1.stop();
        this.title2.stop();
    }
}

