/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import ea.Bild;
import ea.Knoten;
import ea.Raum;
import java.lang.reflect.Type;

public class NPC2
extends Knoten {
    @Expose
    public String name;
    @Expose
    public String displayName;
    private Bild img;
    private final String highlighterPath = "./Assets/NPCs/highLight.png";
    private final String specialBedHighlighterPath = "./Assets/NPCs/highLightBed.png";
    private final Bild highLightImg;
    private boolean highlightState = true;
    @Expose
    private float posX;
    @Expose
    private float posY;
    @Expose
    private float relativePosX;
    @Expose
    private float relativePosY;
    @Expose
    private int houseNumber;
    @Expose
    public String lastLine;

    public NPC2(int pX, int pY, int rX, int rY, int hN, String n, String mlastLine, String dN) {
        this.posX = pX;
        this.posY = pY;
        this.relativePosX = rX;
        this.relativePosY = rY;
        this.name = n;
        this.houseNumber = hN;
        this.lastLine = mlastLine;
        this.displayName = dN;
        try {
            String path = "./Assets/NPCs/" + this.name + ".png";
            this.img = new Bild((float)pX, (float)pY, path);
        }
        catch (Exception e) {
            System.out.println("NPC2: Fehler beim importieren der Datei");
            System.out.println("NPC2: " + e);
            e.printStackTrace();
        }
        this.highLightImg = this.name.equals("zzz") ? new Bild(this.posX, this.posY, "./Assets/NPCs/highLightBed.png") : new Bild(this.posX + 2.0f, this.posY - 50.0f, "./Assets/NPCs/highLight.png");
        this.add((Raum)this.highLightImg);
        this.add((Raum)this.img);
    }

    public void setLastLine(String code) {
        this.lastLine = code;
    }

    @Override
    public void verschieben(float dX, float dY) {
        this.posX += dX;
        this.posY += dY;
        super.verschieben(dX, dY);
    }

    @Override
    public void positionSetzen(float x, float y) {
        this.posX = x;
        this.posY = y;
        super.positionSetzen(x, y);
    }

    public boolean schneidetNEU(Raum r) {
        if (this.highlightState) {
            return this.schneidet(r);
        }
        return this.img.schneidet(r);
    }

    public void setRelativPos(int x, int y) {
        System.out.println("DIE RELITVE POS WIRD GESETZTT AUF : " + y + "| y:" + y);
        this.relativePosX = x;
        this.relativePosY = y;
    }

    public float getRelativPosX() {
        return this.relativePosX;
    }

    public float getRelativPosY() {
        return this.relativePosY;
    }

    public void setHouseNumber(int houseNumber) {
        this.houseNumber = houseNumber;
    }

    public float getPosY() {
        return this.posY;
    }

    public float getPosX() {
        return this.posX;
    }

    public int getHouseNumber() {
        return this.houseNumber;
    }

    public boolean isInHouse() {
        if (this.houseNumber == -1) {
            return false;
        }
        if (this.houseNumber >= 0) {
            return true;
        }
        System.out.println("NPC2: Fetter Fail: Spieler ist in dem negativen Haus: " + this.houseNumber + " und nicht >=(-1)");
        return false;
    }

    public void setHighlightState(boolean h) {
        this.highlightState = h;
        this.highLightImg.sichtbarSetzen(this.highlightState);
    }

    public String toString() {
        return "NPC2{name='" + this.name + '\'' + ", img=" + this.img + ", highlighterPath='" + "./Assets/NPCs/highLight.png" + '\'' + ", highLightImg=" + this.highLightImg + ", highlightState=" + this.highlightState + ", posX=" + this.posX + ", posY=" + this.posY + ", relativePosX=" + this.relativePosX + ", relativePosY=" + this.relativePosY + ", houseNumber=" + this.houseNumber + ", lastLine='" + this.lastLine + '\'' + '}';
    }

    public static class Deserializer
    implements JsonDeserializer<NPC2> {
        @Override
        public NPC2 deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return new NPC2(jsonObject.get("posX").getAsInt(), jsonObject.get("posY").getAsInt(), jsonObject.get("relativePosX").getAsInt(), jsonObject.get("relativePosY").getAsInt(), jsonObject.get("houseNumber").getAsInt(), jsonObject.get("name").getAsString(), jsonObject.get("lastLine").getAsString(), jsonObject.get("displayName").getAsString());
        }
    }
}

