/*
 * Decompiled with CFR 0.152.
 */
import ea.Bild;
import ea.Knoten;
import ea.Punkt;
import ea.Raum;
import java.util.ArrayList;
import java.util.Collections;

public class Minigame2
extends Knoten {
    private Player AP;
    private int offsetX = 0;
    private int offsetY = 0;
    private int tileCount = 8;
    private int leverCount = 8;
    private int tileSize = 200;
    private int rowPos = 0;
    private int originalSpeed = 10;
    private int speed;
    private int bottomEdge = 900;
    private int row0_firstPos = 0;
    private int row1_firstPos = 0;
    private int row2_firstPos = 0;
    private Punkt row0_TL_POS = new Punkt(200.0f, 100.0f);
    private Punkt row1_TL_POS = new Punkt(500.0f, 100.0f);
    private Punkt row2_TL_POS = new Punkt(800.0f, 100.0f);
    private String mainPath = "./Assets/Minigames/SlotMachine/";
    private Bild frameImg;
    private Bild[] leverImgs = new Bild[10];
    private Bild[] row0_tileImgs = new Bild[this.tileCount];
    private Bild[] row1_tileImgs = new Bild[this.tileCount];
    private Bild[] row2_tileImgs = new Bild[this.tileCount];
    private int[] row0_tileImgsPointer = new int[this.tileCount];
    private int[] row1_tileImgsPointer = new int[this.tileCount];
    private int[] row2_tileImgsPointer = new int[this.tileCount];
    private boolean rolling = false;
    private int decelerationCounterOriginal = 80;
    private int decelerationCounter;
    private boolean active = false;

    public Minigame2(Player AP) {
        this.AP = AP;
        this.InitImgs();
    }

    private void InitImgs() {
        for (int i = 0; i < this.tileCount; ++i) {
            String path = this.mainPath + "tile" + i + ".png";
            try {
                this.row0_tileImgs[i] = new Bild(path);
                this.row1_tileImgs[i] = new Bild(path);
                this.row2_tileImgs[i] = new Bild(path);
                this.add(this.row0_tileImgs[i], this.row1_tileImgs[i], this.row2_tileImgs[i]);
                this.row0_tileImgs[i].sichtbarSetzen(false);
                this.row1_tileImgs[i].sichtbarSetzen(false);
                this.row2_tileImgs[i].sichtbarSetzen(false);
                continue;
            }
            catch (Exception e) {
                System.out.println("Minigame2: " + e);
            }
        }
        try {
            String path = this.mainPath + "frame.png";
            this.frameImg = new Bild((float)this.offsetX, (float)this.offsetY, path);
            this.add((Raum)this.frameImg);
            this.frameImg.sichtbarSetzen(false);
        }
        catch (Exception e) {
            System.out.println("Minigame2: " + e);
        }
    }

    private void shufflePointers() {
        this.row0_tileImgsPointer = this.giveShuffeldArray(this.tileCount);
        this.row1_tileImgsPointer = this.giveShuffeldArray(this.tileCount);
        this.row2_tileImgsPointer = this.giveShuffeldArray(this.tileCount);
    }

    public void startGame() {
        this.AP.addMoney(-1);
        this.active = true;
        this.frameImg.sichtbarSetzen(true);
        this.rowPos = 0;
        this.row0_firstPos = 0;
        this.row1_firstPos = 0;
        this.row2_firstPos = 0;
        this.rolling = true;
        this.speed = this.originalSpeed;
        this.decelerationCounter = this.decelerationCounterOriginal;
        this.shufflePointers();
        this.setRows();
    }

    public void tick() {
        if (this.active && this.rolling) {
            switch (this.rowPos) {
                case 0: {
                    int i;
                    for (i = 0; i < this.tileCount; ++i) {
                        this.row0_tileImgs[this.row0_tileImgsPointer[i]].verschieben(0.0f, this.speed);
                    }
                    if (!(this.row0_tileImgs[this.row0_tileImgsPointer[this.row0_firstPos]].getY() >= (float)(this.bottomEdge + this.offsetY))) break;
                    this.row0_tileImgs[this.row0_tileImgsPointer[this.row0_firstPos]].verschieben(0.0f, -this.tileCount * this.tileSize);
                    ++this.row0_firstPos;
                    if (this.row0_firstPos < this.tileCount) break;
                    this.row0_firstPos = 0;
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < this.tileCount; ++i) {
                        this.row1_tileImgs[this.row1_tileImgsPointer[i]].verschieben(0.0f, this.speed);
                    }
                    if (!(this.row1_tileImgs[this.row1_tileImgsPointer[this.row1_firstPos]].getY() >= (float)(this.bottomEdge + this.offsetY))) break;
                    this.row1_tileImgs[this.row1_tileImgsPointer[this.row1_firstPos]].verschieben(0.0f, -this.tileCount * this.tileSize);
                    ++this.row1_firstPos;
                    if (this.row1_firstPos < this.tileCount) break;
                    this.row1_firstPos = 0;
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < this.tileCount; ++i) {
                        this.row2_tileImgs[this.row2_tileImgsPointer[i]].verschieben(0.0f, this.speed);
                    }
                    if (!(this.row2_tileImgs[this.row2_tileImgsPointer[this.row2_firstPos]].getY() >= (float)(this.bottomEdge + this.offsetY))) break;
                    this.row2_tileImgs[this.row2_tileImgsPointer[this.row2_firstPos]].verschieben(0.0f, -this.tileCount * this.tileSize);
                    ++this.row2_firstPos;
                    if (this.row2_firstPos < this.tileCount) break;
                    this.row2_firstPos = 0;
                }
            }
            --this.decelerationCounter;
            if (this.decelerationCounter <= 0) {
                this.decelerationCounter = this.decelerationCounterOriginal;
                --this.speed;
            }
            if (this.speed <= 0) {
                if (this.rowPos >= 2) {
                    System.out.println("Minigame2: " + this.rowPos + " ist jz unten angekommen");
                    this.rolling = false;
                    int jack = this.analyseJackpot();
                    System.out.println("An allen  Stelle ist der Jackpot wert = " + jack);
                    this.AP.addMoney(jack);
                    this.startGame();
                } else {
                    System.out.println("Minigame2: " + this.rowPos + " ist jz unten angekommen");
                    this.speed = this.originalSpeed;
                    ++this.rowPos;
                }
            }
        }
    }

    private int analyseJackpot() {
        int check = 4;
        int[] result = new int[check];
        for (int i = 0; i < check; ++i) {
            int pos = this.row0_firstPos + i;
            if (pos > this.tileCount - 1) {
                pos -= this.tileCount;
            }
            result[i] = this.checkJackpot(pos);
        }
        int pot = 0;
        for (int i = 0; i < check; ++i) {
            pot += result[i];
        }
        return pot;
    }

    private int checkJackpot(int pos) {
        int i = pos;
        int jackpot = 0;
        if (this.row0_tileImgsPointer[i] == this.row1_tileImgsPointer[i] && this.row0_tileImgsPointer[i] == this.row2_tileImgsPointer[i] && this.row1_tileImgsPointer[i] == this.row2_tileImgsPointer[i]) {
            jackpot = 30;
        } else if (this.row0_tileImgsPointer[i] == this.row1_tileImgsPointer[i]) {
            jackpot = 1;
        } else if (this.row1_tileImgsPointer[i] == this.row2_tileImgsPointer[i]) {
            jackpot = 1;
        }
        return jackpot;
    }

    private void setRows() {
        int i;
        for (i = 0; i < this.tileCount; ++i) {
            this.row0_tileImgs[this.row0_tileImgsPointer[i]].sichtbarSetzen(true);
            this.row0_tileImgs[this.row0_tileImgsPointer[i]].positionSetzen(this.row0_TL_POS);
            this.row0_tileImgs[this.row0_tileImgsPointer[i]].verschieben(this.offsetX, this.offsetY);
            this.row0_tileImgs[this.row0_tileImgsPointer[i]].verschieben(0.0f, -(i + 1) * this.tileSize);
        }
        for (i = 0; i < this.tileCount; ++i) {
            this.row1_tileImgs[this.row1_tileImgsPointer[i]].sichtbarSetzen(true);
            this.row1_tileImgs[this.row1_tileImgsPointer[i]].positionSetzen(this.row1_TL_POS);
            this.row1_tileImgs[this.row1_tileImgsPointer[i]].verschieben(this.offsetX, this.offsetY);
            this.row1_tileImgs[this.row1_tileImgsPointer[i]].verschieben(0.0f, -(i + 1) * this.tileSize);
        }
        for (i = 0; i < this.tileCount; ++i) {
            this.row2_tileImgs[this.row2_tileImgsPointer[i]].sichtbarSetzen(true);
            this.row2_tileImgs[this.row2_tileImgsPointer[i]].positionSetzen(this.row2_TL_POS);
            this.row2_tileImgs[this.row2_tileImgsPointer[i]].verschieben(this.offsetX, this.offsetY);
            this.row2_tileImgs[this.row2_tileImgsPointer[i]].verschieben(0.0f, -(i + 1) * this.tileSize);
        }
    }

    private int[] giveShuffeldArray(int size) {
        int i;
        int[] arraySolution = new int[size];
        ArrayList<Integer> solution = new ArrayList<Integer>();
        for (i = 0; i < size; ++i) {
            solution.add(i);
        }
        Collections.shuffle(solution);
        for (i = 0; i < solution.size(); ++i) {
            arraySolution[i] = (Integer)solution.get(i);
        }
        return arraySolution;
    }

    public boolean isActive() {
        return this.active;
    }
}

