/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import ea.Bild;
import ea.Knoten;
import ea.Punkt;
import ea.Raum;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;

public class Map3
extends Knoten {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    private int numberofB = -1;
    private int PlayerW;
    private int PlayerH;
    private boolean visiting;
    private int houseNumber = -1;
    private ImageCollider mapHitbox;
    private Bild backgroundImg;
    private String defaultPath = "./Assets/Houses/";
    private String pathHitboxImg = "./Assets/Map/Map3_coll.png";
    private String pathMainImg = "./Assets/Map/";
    private String pathBackgroundImg = "./Assets/Tests/blur.png";
    private HashMap<String, Haus> MAP;
    private Bild[] mapImgs = new Bild[4];
    private Punkt mapCenter = new Punkt(4896.0f, 2541.0f);
    private ImageCollider[] houseHitbox;
    private Bild[] houseImgs;
    private int[] RedColorCodes;
    private int[][] intSpawnPos;
    private boolean[] defaultLock;
    private int lastWhiteX = -1;
    private int lastWhiteY = -1;
    private float lastFinalPosX;
    private float lastFinalPosY;
    private NpcController2 npc_C;
    private SoundController sound_c;
    private GameSaver gamesaver;
    private Player player;
    private ItemController itemC;
    private int blackThreshold = MAIN.blackThreshold;

    public Map3(NpcController2 NPC_C, SoundController sc, Player ap, GameSaver gs, ItemController iC) {
        this.npc_C = NPC_C;
        this.sound_c = sc;
        this.player = ap;
        this.gamesaver = gs;
        this.itemC = iC;
        this.PlayerW = (int)this.player.getBreite();
        this.PlayerH = (int)this.player.getHoehe();
        this.houseNumber = gs.getHouseNumber();
        this.readJSON();
        this.InitArrays();
        this.FillArrays();
        this.loadStartPos();
    }

    private void InitArrays() {
        this.numberofB = this.MAP.size();
        this.houseHitbox = new ImageCollider[this.numberofB];
        this.houseImgs = new Bild[this.numberofB];
        this.RedColorCodes = new int[this.numberofB];
        this.intSpawnPos = new int[this.numberofB][2];
        this.defaultLock = new boolean[this.numberofB];
    }

    private void FillArrays() {
        try {
            this.mapImgs[0] = new Bild(0.0f, 0.0f, this.pathMainImg + "topLeft.png");
            this.mapImgs[1] = new Bild(this.mapCenter.x, 0.0f, this.pathMainImg + "topRight.png");
            this.mapImgs[2] = new Bild(this.mapCenter.x, this.mapCenter.y, this.pathMainImg + "bottomRight.png");
            this.mapImgs[3] = new Bild(0.0f, this.mapCenter.y, this.pathMainImg + "bottomLeft.png");
            this.add(this.mapImgs[0], this.mapImgs[1], this.mapImgs[2], this.mapImgs[3]);
        }
        catch (Exception e) {
            System.out.println("Fehler in der Map Klasse: Bild bei " + this.pathMainImg + " kann nicht gefunden werden!");
            System.out.println(e);
        }
        try {
            this.backgroundImg = new Bild(0.0f, 0.0f, this.pathBackgroundImg);
            this.backgroundImg.setOpacity(1.0f);
            this.backgroundImg.sichtbarSetzen(false);
            this.add((Raum)this.backgroundImg);
        }
        catch (Exception e) {
            System.out.println("Fehler in der Map Klasse: Bild bei " + this.pathBackgroundImg + " kann nicht gefunden werden!");
            System.out.println(e);
        }
        this.mapHitbox = new ImageCollider(this.pathHitboxImg);
        this.add((Raum)this.mapHitbox);
        int i = 0;
        for (String key : this.MAP.keySet()) {
            Haus element = this.MAP.get(key);
            String tempPath = this.defaultPath + element.name + ".png";
            String tempCollPath = this.defaultPath + element.name + "_coll.png";
            try {
                this.houseImgs[i] = new Bild(0.0f, 0.0f, tempPath);
                this.houseImgs[i].sichtbarSetzen(false);
                this.add((Raum)this.houseImgs[i]);
            }
            catch (Exception e) {
                System.out.println("Fehler in der Map Klasse: Bild bei " + tempPath + " kann nicht gefunden werden!");
                System.out.println(e);
            }
            this.houseHitbox[i] = new ImageCollider(tempCollPath);
            this.houseHitbox[i].sichtbarSetzen(false);
            this.add((Raum)this.houseHitbox[i]);
            this.intSpawnPos[i][0] = element.intSpawnX;
            this.intSpawnPos[i][1] = element.intSpawnY;
            this.defaultLock[i] = element.defaultLock;
            this.RedColorCodes[i] = element.RedColorCode;
            ++i;
        }
        System.out.println("MAP3, ARRAYS SIND GEF\u00dcLLT");
    }

    public void loadStartPos() {
        System.out.println("Map3: Aus den gespeicherten GameSave Daten wird die startPos des Spielers gelesen.");
        int houseN = this.gamesaver.getHouseNumber();
        this.leaveHouse();
        this.player.positionSetzen(this.gamesaver.getPosX(), this.gamesaver.getPosY());
        if (houseN != -1) {
            System.out.println("Aus loadStartPos mit Hausnummer -> betreten:" + houseN);
            this.enterHouse(houseN);
        }
    }

    public void FixInteriorPos(Player AP, int HouseN) {
        float imgWidth = this.houseImgs[HouseN].getBreite();
        float imgHeight = this.houseImgs[HouseN].getHoehe();
        float finalPosX = AP.getPosX() - imgWidth / 2.0f;
        float finalPosY = AP.getPosY() - imgHeight / 2.0f;
        this.lastFinalPosX = finalPosX;
        this.lastFinalPosY = finalPosY;
        this.houseHitbox[HouseN].setOffset((int)finalPosX, (int)finalPosY);
        this.houseImgs[HouseN].positionSetzen(finalPosX, finalPosY);
        this.npc_C.enterHouse(HouseN, (int)finalPosX, (int)finalPosY);
        this.itemC.enterHouse(HouseN, (int)finalPosX, (int)finalPosY);
        AP.positionSetzen((float)this.intSpawnPos[HouseN][0] + finalPosX, (float)this.intSpawnPos[HouseN][1] + finalPosY);
    }

    public String getOffsetPosString() {
        String returnText;
        if (this.houseNumber == -1) {
            returnText = "ist in keinem Haus!";
        } else {
            float relativeX = this.player.getPosX() - this.lastFinalPosX;
            float relativeY = this.player.getPosY() - this.lastFinalPosY;
            returnText = "x: " + relativeX + " | y: " + relativeY;
        }
        return returnText;
    }

    public void enterHouse(int HouseN) {
        this.sichtbarSetzen(false);
        this.backgroundImg.sichtbarSetzen(true);
        if (this.lastWhiteX != -1) {
            this.gamesaver.setLastOutsidePos(this.lastWhiteX, this.lastWhiteY);
        }
        this.gamesaver.setHouseNumber(HouseN);
        System.out.println("Map3: Spieler betritt Haus Nummer: " + HouseN);
        this.sound_c.playDoorSound();
        this.hideAllHouses();
        int x = this.player.positionX();
        int y = this.player.positionY();
        this.backgroundImg.mittelpunktSetzen(x, y);
        this.houseImgs[HouseN].sichtbarSetzen(true);
        this.houseHitbox[HouseN].sichtbarSetzen(true);
        this.FixInteriorPos(this.player, HouseN);
        this.houseNumber = HouseN;
        this.visiting = true;
        this.sichtbarSetzen(true);
    }

    public void leaveHouse() {
        this.gamesaver.setHouseNumber(-1);
        this.lastWhiteX = this.gamesaver.getLastOutsidePosX();
        this.lastWhiteY = this.gamesaver.getLastOutsidePosY();
        this.sound_c.playDoorSound();
        this.visiting = false;
        this.houseNumber = -1;
        this.hideAllHouses();
        this.backgroundImg.sichtbarSetzen(false);
        this.player.positionSetzen(this.lastWhiteX, this.lastWhiteY);
        this.npc_C.leaveHouse();
        this.itemC.leaveHouse();
    }

    public void hideAllHouses() {
        for (int i = 0; i < this.numberofB; ++i) {
            this.houseImgs[i].sichtbarSetzen(false);
            this.houseHitbox[i].sichtbarSetzen(false);
        }
    }

    public Color decodeHex(int hexC) {
        int r = (hexC & 0xFF0000) >> 16;
        int g = (hexC & 0xFF00) >> 8;
        int b = hexC & 0xFF;
        return new Color(r, g, b);
    }

    public boolean isWalkable2(DummyPlayer dp, Player ap) {
        if (!this.visiting) {
            ImageCollider.ColliderReturnType result = this.mapHitbox.scanSurrounding(dp);
            if (!result.isInColor()) {
                if (result.isBlack()) {
                    return false;
                }
                if (result.isWhite()) {
                    this.lastWhiteX = ap.positionX();
                    this.lastWhiteY = ap.positionY();
                    return true;
                }
                System.out.println("Map3: Komisches Ergebniss der Farbanalyse - PR\u00dcFEN");
                return false;
            }
            int match = -1;
            for (int i = 0; i < this.numberofB; ++i) {
                if (result.getColor() != this.RedColorCodes[i]) continue;
                match = i;
            }
            if (match == -1) {
                System.out.println("Map3: Der Spieler ist in einer Farbe die nicht in der Tabelle eingetragen wurde!");
                System.out.println("Map3: Gru\u00df an das Grafikteam!");
                return false;
            }
            this.enterHouse(match);
            return true;
        }
        ImageCollider.ColliderReturnType result2 = this.houseHitbox[this.houseNumber].scanSurrounding(dp);
        if (result2.isOutOfBounds()) {
            this.leaveHouse();
            return false;
        }
        if (result2.isBlack()) {
            return false;
        }
        if (result2.isWhite()) {
            return true;
        }
        System.out.println("Map3: Komisches Ergebniss der Farbanalyse beim Besuchen (visiting=true)- PR\u00dcFEN");
        return false;
    }

    public int getHouseNumber() {
        return this.houseNumber;
    }

    public boolean isVisiting() {
        return this.visiting;
    }

    public void toggleVisting() {
        this.visiting = !this.visiting;
    }

    private void readJSON() {
        Gson gson = new Gson();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/KarteNew.json"));
            Type MapType = new TypeToken<HashMap<String, Haus>>(){}.getType();
            this.MAP = (HashMap)gson.fromJson((Reader)bufferedReader, MapType);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("\u001b[35mMap3: Ein Fehler beim Lesen der Json Datei. Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
            System.out.println("\u001b[35mMap3: Eigentlich kann nur das Grafikteam schuld sein...\u001b[0m");
        }
    }

    public class Haus {
        String name;
        int RedColorCode;
        int intSpawnX;
        int intSpawnY;
        boolean defaultLock;
    }
}

