/*
 * Decompiled with CFR 0.152.
 */
import ea.Bild;
import ea.Knoten;
import ea.Raum;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

class ImageCollider
extends Knoten {
    private String ImgPath = "./Assets/Tests/coll2.png";
    private int PlayerW = 48;
    private int PlayerH = 90;
    private int offsetX;
    private int offsetY;
    private Bild displayImg;
    private BufferedImage colliderImg = null;
    private File f = null;
    private int blackThreshold = MAIN.blackThreshold;
    private int whiteThreshold = MAIN.whiteThreshold;

    public ImageCollider(String path) {
        this.ImgPath = path;
        try {
            this.f = new File(this.ImgPath);
            this.colliderImg = ImageIO.read(this.f);
        }
        catch (IOException e) {
            System.out.println("Fehler in der ImageCollider Klasse: Bild bei " + this.ImgPath + " kann nicht gefunden werden!");
            System.out.println(e);
        }
        this.InitImage();
    }

    private void InitImage() {
        try {
            this.displayImg = new Bild(0.0f, 0.0f, this.ImgPath);
        }
        catch (Exception e) {
            System.out.println("Fehler in der ImageCollider Klasse: Bild bei " + this.ImgPath + " kann nicht gefunden werden!");
            System.out.println(e);
        }
        this.displayImg.sichtbarSetzen(false);
        this.add((Raum)this.displayImg);
    }

    private void setDisplayImageVisibility(boolean v) {
        this.displayImg.sichtbarSetzen(v);
    }

    public void setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        this.displayImg.positionSetzen(x, y);
    }

    public boolean TestColl(int ObjectX, int ObjectY) {
        int r2;
        int p;
        int i;
        ObjectX -= this.offsetX;
        ObjectY -= this.offsetY;
        boolean coll = false;
        for (i = 0; i < this.PlayerH; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(ObjectX, i + ObjectY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            r2 = p >> 16 & 0xFF;
            if (r2 >= 100) continue;
            coll = true;
        }
        for (i = 0; i < this.PlayerH; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(ObjectX + this.PlayerW, i + ObjectY);
            }
            catch (Exception r2) {
                // empty catch block
            }
            r2 = p >> 16 & 0xFF;
            if (r2 >= 100) continue;
            coll = true;
        }
        for (i = 0; i < this.PlayerW; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(ObjectX + i, ObjectY);
            }
            catch (Exception r3) {
                // empty catch block
            }
            r2 = p >> 16 & 0xFF;
            if (r2 >= 100) continue;
            coll = true;
        }
        for (i = 0; i < this.PlayerW; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(ObjectX + i, this.PlayerH + ObjectY);
            }
            catch (Exception r4) {
                // empty catch block
            }
            r2 = p >> 16 & 0xFF;
            if (r2 >= 100) continue;
            coll = true;
        }
        return coll;
    }

    public int GetStatus(int ObjectX, int ObjectY) {
        boolean isBlack;
        int r;
        int p;
        int i;
        ObjectX -= this.offsetX;
        ObjectY -= this.offsetY;
        int redColor = 0;
        for (i = 0; i < this.PlayerH; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(ObjectX, i + ObjectY);
            }
            catch (Exception e) {
                System.out.println(e);
                System.out.println("Fehler in der ImageCollider Klasse: Spieler ist nicht in der Fl\u00e4che eines Kolliders");
            }
            r = p >> 16 & 0xFF;
            if (r == 0) {
                isBlack = true;
                continue;
            }
            redColor = r;
        }
        for (i = 0; i < this.PlayerH; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(ObjectX + this.PlayerW, i + ObjectY);
            }
            catch (Exception e) {
                System.out.println(e);
                System.out.println("Fehler in der ImageCollider Klasse: Spieler ist nicht in der Fl\u00e4che eines Kolliders");
            }
            r = p >> 16 & 0xFF;
            if (r == 0) {
                isBlack = true;
                continue;
            }
            redColor = r;
        }
        for (i = 0; i < this.PlayerW; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(ObjectX + i, ObjectY);
            }
            catch (Exception e) {
                System.out.println(e);
                System.out.println("Fehler in der ImageCollider Klasse: Spieler ist nicht in der Fl\u00e4che eines Kolliders");
            }
            r = p >> 16 & 0xFF;
            if (r == 0) {
                isBlack = true;
                continue;
            }
            redColor = r;
        }
        for (i = 0; i < this.PlayerW; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(ObjectX + i, this.PlayerH + ObjectY);
            }
            catch (Exception e) {
                System.out.println(e);
                System.out.println("Fehler in der ImageCollider Klasse: Spieler ist nicht in der Fl\u00e4che eines Kolliders");
            }
            r = p >> 16 & 0xFF;
            if (r == 0) {
                isBlack = true;
                continue;
            }
            redColor = r;
        }
        return redColor;
    }

    public boolean TestCollPlayer(DummyPlayer dp) {
        int x = (int)dp.getX();
        int y = (int)dp.getY();
        System.out.println("Relelle pos ist: " + x + "," + y);
        return this.TestColl(x, y);
    }

    public boolean AllowWalk(DummyPlayer dp) {
        return !this.TestCollPlayer(dp);
    }

    public int getWalkColor(DummyPlayer dp) {
        int x = (int)dp.getX();
        int y = (int)dp.getY();
        System.out.println("Relelle pos ist: " + x + "," + y);
        return this.GetStatus(x, y);
    }

    public ColliderReturnType scanSurrounding(DummyPlayer dp) {
        int r;
        int p;
        int i;
        int playerX = dp.positionX();
        int playerY = dp.positionY();
        playerX -= this.offsetX;
        playerY -= this.offsetY;
        int redColor = 0;
        boolean isBlack = false;
        boolean isWhite = false;
        boolean isOutOfBounds = false;
        for (i = 0; i < this.PlayerH; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(playerX, i + playerY);
            }
            catch (Exception e) {
                isOutOfBounds = true;
            }
            r = p >> 16 & 0xFF;
            if (r <= this.blackThreshold) {
                isBlack = true;
                continue;
            }
            if (r >= this.whiteThreshold) {
                isWhite = true;
                continue;
            }
            redColor = r;
        }
        for (i = 0; i < this.PlayerH; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(playerX + this.PlayerW, i + playerY);
            }
            catch (Exception e) {
                isOutOfBounds = true;
            }
            r = p >> 16 & 0xFF;
            if (r <= this.blackThreshold) {
                isBlack = true;
                continue;
            }
            if (r >= this.whiteThreshold) {
                isWhite = true;
                continue;
            }
            redColor = r;
        }
        for (i = 0; i < this.PlayerW; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(playerX + i, playerY);
            }
            catch (Exception e) {
                isOutOfBounds = true;
            }
            r = p >> 16 & 0xFF;
            if (r <= this.blackThreshold) {
                isBlack = true;
                continue;
            }
            if (r >= this.whiteThreshold) {
                isWhite = true;
                continue;
            }
            redColor = r;
        }
        for (i = 0; i < this.PlayerW; ++i) {
            p = 0;
            try {
                p = this.colliderImg.getRGB(playerX + i, this.PlayerH + playerY);
            }
            catch (Exception e) {
                isOutOfBounds = true;
            }
            r = p >> 16 & 0xFF;
            if (r <= this.blackThreshold) {
                isBlack = true;
                continue;
            }
            if (r >= this.whiteThreshold) {
                isWhite = true;
                continue;
            }
            redColor = r;
        }
        return new ColliderReturnType(isBlack, isWhite, redColor, isOutOfBounds);
    }

    class ColliderReturnType {
        private boolean isBlack;
        private boolean isWhite;
        private boolean inColor;
        private int color;
        private boolean isOutOfBounds;

        public ColliderReturnType(boolean b, boolean w, int color, boolean outOfBounds) {
            this.isBlack = b;
            this.isWhite = w;
            this.color = color;
            this.isOutOfBounds = outOfBounds;
        }

        public boolean isBlack() {
            return this.isBlack;
        }

        public boolean isWhite() {
            return this.isWhite;
        }

        public int getColor() {
            return this.color;
        }

        public boolean isOutOfBounds() {
            return this.isOutOfBounds;
        }

        public boolean isInColor() {
            return this.color != 0;
        }
    }
}

