/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class GameSaver {
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    private Save saveState = new Save();
    private final String gameSaveFilePath = "./Assets/Files/GameSave.json";

    public GameSaver() {
        this.readJSON();
        System.out.println("GameSaver: Erster Save TEST gelesen: " + this.saveState);
    }

    public void startNewGame() {
        try {
            this.readJSON();
            this.saveState.setName("DEFAULT");
            this.saveState.setPosX(1100);
            this.saveState.setPosY(1100);
            this.saveState.setWalkspeed(0);
            this.saveState.setHouseNumber(0);
            this.saveState.setLastOutsidePos(1000, 1000);
            this.saveState.setTemporalPosition("Tag 1 Abschnitt 1 (Start Zeit)");
            this.saveJSON();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("FETTER FEHLER BEIM \u00dcBERSCHREIBEN " + this.saveState);
        }
    }

    public void SavePlayer(Player Player2) {
        this.saveState.setName(Player2.getName());
        this.saveState.setPosX((int)Player2.getPosX());
        this.saveState.setPosY((int)Player2.getPosY());
        this.saveState.setWalkspeed(Player2.getWalkspeed());
    }

    public List<String> getItems() {
        return this.saveState.items;
    }

    public void addItem(String item) {
        this.saveState.items.add(item);
        this.saveJSON();
    }

    public void addLine(String code) {
        System.out.println("GameSaver: Die Line mir dem Code: " + code + " wurde gespeichert");
        this.saveState.lines.add(code);
        this.saveJSON();
    }

    public List<String> getLines() {
        return this.saveState.lines;
    }

    public int getWalkspeed() {
        return this.saveState.walkspeed;
    }

    public void setWalkspeed(int w) {
        this.saveState.walkspeed = w;
    }

    public void setTemporalPosition(String newTemporalPosition) {
        this.saveState.temporalPosition = newTemporalPosition;
        this.saveJSON();
    }

    public void setHouseNumber(int HouseNumber) {
        this.saveState.setHouseNumber(HouseNumber);
    }

    public int getHouseNumber() {
        return this.saveState.houseNumber;
    }

    public int getPosX() {
        return this.saveState.posX;
    }

    public int getPosY() {
        return this.saveState.posY;
    }

    public void setLastOutsidePos(int x, int y) {
        this.saveState.lastOutsidePosX = x;
        this.saveState.lastOutsidePosY = y;
    }

    public int getLastOutsidePosX() {
        return this.saveState.lastOutsidePosX;
    }

    public int getLastOutsidePosY() {
        return this.saveState.lastOutsidePosY;
    }

    public String getTemporalPosition() {
        return this.saveState.temporalPosition;
    }

    private void readJSON() {
        Gson gson = new GsonBuilder().create();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/GameSave.json"));
            Type JsonType = new TypeToken<Save>(){}.getType();
            this.saveState = (Save)gson.fromJson((Reader)bufferedReader, JsonType);
            System.out.println("\u001b[32mGameSaver: JSON(./Assets/Files/GameSave.json) erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mGameSaver: Ein Fehler beim Lesen der Json Datei(./Assets/Files/GameSave.json). Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }

    public void saveJSON() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileOutputStream fout = new FileOutputStream("./Assets/Files/GameSave.json");
            fout.write(gson.toJson(this.saveState).getBytes());
            fout.close();
            System.out.println("\u001b[32mGameSaver: JSON(./Assets/Files/GameSave.json) erfolgreich gespeichert\u001b[0m");
        }
        catch (Exception e) {
            System.out.println("\u001b[35mEin Fehler beim Schreiben der Json Datei. Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
        this.readJSON();
    }

    class Save {
        public String name;
        public int posX;
        public int posY;
        public int walkspeed;
        public int houseNumber;
        public int lastOutsidePosX;
        public int lastOutsidePosY;
        public String temporalPosition;
        public List<String> items = new ArrayList<String>();
        public List<String> lines = new ArrayList<String>();

        public void setName(String name) {
            this.name = name;
        }

        public void setPosX(int posX) {
            this.posX = posX;
        }

        public void setPosY(int posY) {
            this.posY = posY;
        }

        public void setWalkspeed(int walkspeed) {
            this.walkspeed = walkspeed;
        }

        public void setHouseNumber(int houseNumber) {
            this.houseNumber = houseNumber;
        }

        public void setTemporalPosition(String temporalPosition) {
            this.temporalPosition = temporalPosition;
        }

        public void setLastOutsidePos(int x, int y) {
            this.lastOutsidePosX = x;
            this.lastOutsidePosY = y;
        }

        public String toString() {
            return "Save{name='" + this.name + '\'' + ", posX=" + this.posX + ", posY=" + this.posY + ", walkspeed=" + this.walkspeed + ", houseNumber=" + this.houseNumber + ", lastOutSidePosX=" + this.lastOutsidePosX + ", lastOutSidePosY=" + this.lastOutsidePosY + ", temporalPosition='" + this.temporalPosition + '\'' + ", items=" + this.items + ", lines=" + this.lines + '}';
        }
    }
}

