/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import ea.Bild;
import ea.Farbe;
import ea.Knoten;
import ea.Raum;
import ea.Text;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DialogController4
extends Knoten {
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    private final String dialogLinesPath = "./Assets/Files/Dialoge.json";
    private final String dialogPacketsPath = "./Assets/Files/DialogPackets.json";
    private String globalTemporalPosition = "Tag 1 Abschnitt 1 (Start Zeit)";
    private boolean active = false;
    private boolean waitingForInput = false;
    private boolean playingLastLine = false;
    private final NpcController2 NPC_Controller2;
    private final GameSaver gameSaver;
    private Map<String, DialogLine> dialogLines;
    private Map<String, Map<String, List<DialogPacket>>> dialogPackets;
    private String defaultPath = "./Assets/Dialoge/";
    private Text displayTextObject;
    private Text displayResponseTextObject;
    private Bild displayDialogBackground;
    private Bild[] displayButtons;
    private int textPosY = 660;
    private String currentDialogCode;
    private boolean lastLineSelf = false;
    private int buttonCursor = 0;
    private boolean oneButtonMode = false;
    private Map<String, String> lastLines = new HashMap<String, String>(){};
    private Map<String, Bild> npcFaces = new HashMap<String, Bild>(){};
    private final int faceLocationX = 100;
    private final int faceLocationY = 620;

    public DialogController4(NpcController2 NPC_C2, GameSaver gs) {
        this.NPC_Controller2 = NPC_C2;
        this.gameSaver = gs;
        this.readJSON_DialogLines();
        this.readJSON_DialogPackets();
        this.addDisplayObjects();
        this.hideWindow();
        this.globalTemporalPosition = this.gameSaver.getTemporalPosition();
        this.NPC_Controller2.updateNpcPositions(this.globalTemporalPosition);
    }

    private void addDisplayObjects() {
        int textPosX = MAIN.x / 2;
        this.displayButtons = new Bild[2];
        try {
            this.displayDialogBackground = new Bild(this.defaultPath + "DialogFenster.png");
            float backPosY = (float)MAIN.y - this.displayDialogBackground.getHoehe();
            this.displayDialogBackground.positionSetzen((float)textPosX - this.displayDialogBackground.getBreite() / 2.0f, backPosY);
            this.displayButtons[0] = new Bild(this.defaultPath + "ButtonWahl0.png");
            this.displayButtons[0].positionSetzen(400.0f, this.textPosY + 50);
            this.displayButtons[1] = new Bild(this.defaultPath + "ButtonWahl1.png");
            this.displayButtons[1].positionSetzen(700.0f, this.textPosY + 50);
            this.add((Raum)this.displayDialogBackground);
            this.add(this.displayButtons[0], this.displayButtons[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("DialogController4: FEHLER beim Importieren der Bilder");
        }
        HashMap<String, NPC2> NpcMap = this.NPC_Controller2.getNPCs();
        this.npcFaces.put("self", new Bild(100.0f, 620.0f, "./Assets/SpielerTest/still.png"));
        for (String name : NpcMap.keySet()) {
            try {
                Bild tempImg = new Bild(100.0f, 620.0f, "./Assets/NPCs/Faces/" + name + ".png");
                this.add((Raum)tempImg);
                tempImg.sichtbarSetzen(false);
                this.npcFaces.put(name, tempImg);
                System.out.println("DialogController4: Neues Gesicht hinzugef\u00fcgt mit dem name: " + name);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("DialogController4: FEHLER beim Importieren der Gesicht-Bilder");
            }
        }
        this.displayResponseTextObject = new Text(textPosX, (float)(this.textPosY + 100), "DEFAULT RESPONSE TEXT");
        this.displayResponseTextObject.farbeSetzen(new Farbe(0, 0, 0));
        this.displayTextObject = new Text(textPosX, (float)(this.textPosY + 20), "DEFAULT TEXT");
        this.displayTextObject.farbeSetzen(new Farbe(0, 0, 0));
        this.add(this.displayTextObject, this.displayResponseTextObject);
    }

    public void startDialog(String npcID) {
        this.waitingForInput = true;
        this.active = true;
        if (this.isDialogPacketPlayable(npcID)) {
            DialogPacket element = this.getPlayableDialogPacket(npcID);
            this.currentDialogCode = element.code;
            this.showWindow();
            this.displayCurrentDialogLine();
        } else {
            this.playLastLine(npcID);
        }
    }

    public void setNpcFace(String npcName) {
        this.hideAllFaces();
        System.out.println("Der NPC mit dem Namen = " + npcName + " wird neben dem Fenster als FACE abgebildet");
        this.npcFaces.get(npcName).sichtbarSetzen(true);
    }

    public void hideAllFaces() {
        for (String name : this.npcFaces.keySet()) {
            this.npcFaces.get(name).sichtbarSetzen(false);
        }
    }

    public void highLightReadyNpcs() {
        this.NPC_Controller2.disguiseAllNPCs();
        if (this.dialogPackets.containsKey(this.globalTemporalPosition)) {
            Map<String, List<DialogPacket>> innnerPacketMap = this.dialogPackets.get(this.globalTemporalPosition);
            Set<String> keys = innnerPacketMap.keySet();
            for (String npcName : innnerPacketMap.keySet()) {
                List<DialogPacket> npcOccs = innnerPacketMap.get(npcName);
                List<String> foundItems = this.gameSaver.getItems();
                List<String> readLines = this.gameSaver.getLines();
                for (DialogPacket packet : npcOccs) {
                    if (foundItems.containsAll(packet.requiredItems)) {
                        if (readLines.containsAll(packet.requiredLines)) {
                            if (packet.forbiddenLines == null) {
                                System.out.println("DialogController4: Es sind alle n\u00f6tigen Items und Zeilen vorhanden und keine Lines verboten f\u00fcr den NPC: " + npcName);
                                this.NPC_Controller2.highLightNpcsByName(npcName);
                                continue;
                            }
                            if (DialogController4.inverseContains(packet.forbiddenLines, readLines)) {
                                System.out.println("DialogController4: Das Dialogpacket hat zwar verbotene Lines, unsere sind aber nicht dabei f\u00fcr den NPC: " + npcName);
                                this.NPC_Controller2.highLightNpcsByName(npcName);
                                continue;
                            }
                            System.out.println("DialogController4: Das Dialogpacket ist verboten!");
                            continue;
                        }
                        System.out.println("DialogController4: highLightReadyNpcs: Es sind alle n\u00f6tigen Items vorhanden, aber nicht alle Zeilen f\u00fcr den NPC: " + npcName);
                        continue;
                    }
                    System.out.println("DialogController4: highLightReadyNpcs(): Es sind nicht alle n\u00f6tigen Items gefunden worden");
                }
            }
        } else {
            System.out.println("DialogController4: FEHLER BEIM HIGHLIGHTEN, DIE N\u00c4CHSTE ZEIT GIBT ES GAR NICHT");
            System.out.println("DialogController4: Die Zeit POS ist:" + this.globalTemporalPosition);
            this.NPC_Controller2.highLightNpcs(null);
        }
    }

    private void displayCurrentDialogLine() {
        System.out.println("DialogController4: displayCurrentDialogLine aufgerufen, Mit dem Code:" + this.currentDialogCode);
        this.playingLastLine = false;
        DialogLine currentLine = this.dialogLines.get(this.currentDialogCode);
        if (currentLine == null) {
            System.out.println("DialogController4: FEHLER: Die Letzte Line war scheinbar korrupt, sie zeigt auf eine andere leere Line: " + currentLine);
        }
        if (this.currentDialogCode == null) {
            System.out.println("DialogController4: FEHLER: Die Letzte Line war scheinbar korrupt, sie hat scheinbar keinen Code??");
        }
        this.gameSaver.addLine(this.currentDialogCode);
        if (currentLine.name.equals("self") && !this.lastLineSelf) {
            this.skipLine();
            this.lastLineSelf = true;
        } else {
            if (!currentLine.name.equals("self")) {
                this.lastLineSelf = false;
                String name = currentLine.name;
                System.out.println("F\u00fcr den NPC mit dem name: " + name + " wird die LastLine: " + this.currentDialogCode + " gespeichert");
                this.lastLines.put(name, this.currentDialogCode);
            }
            if (currentLine.wahl2.equals("")) {
                this.oneButtonMode = true;
                this.updateButtons();
            } else {
                this.oneButtonMode = false;
                this.updateButtons();
            }
            this.setNpcFace(currentLine.name);
            this.setConvText(currentLine.inhalt);
            this.setReplyText();
        }
    }

    private void skipLine() {
        DialogLine currentLine = this.dialogLines.get(this.currentDialogCode);
        System.out.println("DialogController4: Eigener Dialog wird \u00fcbersprungen w\u00e4hrend LastLineSelf=" + this.lastLineSelf);
        this.oneButtonMode = true;
        if (currentLine.wahl1.equals("")) {
            System.out.println("DialogController4: FEHLER: Die n\u00e4chste Line ist scheinbar leer. Ursprungsline: " + this.currentDialogCode);
        }
        this.currentDialogCode = currentLine.wahl1;
        this.displayCurrentDialogLine();
    }

    private void nextLine() {
        System.out.println("DialogController4: Es wurde nextLine() aufgerufen mit der line:" + this.currentDialogCode);
        if (!this.playingLastLine) {
            DialogLine currentLine = this.dialogLines.get(this.currentDialogCode);
            if (this.oneButtonMode) {
                this.buttonCursor = 0;
            }
            if (this.buttonCursor == 0) {
                this.currentDialogCode = currentLine.wahl1;
            }
            if (this.buttonCursor == 1) {
                this.currentDialogCode = currentLine.wahl2;
            }
            if (!currentLine.nextTime.equals("")) {
                System.out.println("NextTime des Dialogs ist nicht mehr leer, und deswegen wir beendet jz wird beendet und gehighlighted");
                this.endDialog();
                this.globalTemporalPosition = currentLine.nextTime;
                this.gameSaver.setTemporalPosition(this.globalTemporalPosition);
                this.highLightReadyNpcs();
                this.NPC_Controller2.updateNpcPositions(this.globalTemporalPosition);
            } else {
                this.displayCurrentDialogLine();
            }
        } else {
            this.endDialog();
        }
    }

    private void saveLastLines() {
        for (String npcName : this.lastLines.keySet()) {
            String code = this.lastLines.get(npcName);
            this.NPC_Controller2.setNpcLastLine(npcName, code);
        }
        this.lastLines.clear();
    }

    private void endDialog() {
        this.hideAllFaces();
        System.out.println("DialogController4: endDialog() aufgerufen");
        this.hideWindow();
        this.active = false;
        this.currentDialogCode = null;
        this.waitingForInput = false;
        this.playingLastLine = false;
        this.NPC_Controller2.resetToLastQuietPos();
        this.saveLastLines();
    }

    private void playLastLine(String npcID) {
        System.out.println("DialogController4: playLastLine() aufgerufen");
        this.oneButtonMode = true;
        this.waitingForInput = true;
        this.playingLastLine = true;
        String lastLineID = this.NPC_Controller2.getNpcLastLine(npcID);
        DialogLine lastLine = this.dialogLines.get(lastLineID);
        this.displayResponseTextObject.sichtbarSetzen(false);
        this.displayTextObject.sichtbarSetzen(true);
        this.displayDialogBackground.sichtbarSetzen(true);
        this.displayButtons[0].sichtbarSetzen(true);
        this.displayButtons[1].sichtbarSetzen(false);
        try {
            String inhalt = lastLine.inhalt;
            this.setConvText(inhalt);
            this.setNpcFace(lastLine.name);
        }
        catch (Exception e) {
            System.out.println("DialogController4: FEHLER: F\u00fcr diesem NPC gibt es scheinbar kein lastLine Eintrag");
            this.displayTextObject.inhaltSetzen("FEHLER! F\u00fcr diesem NPC gibt es scheinbar kein lastLine Eintrag!");
        }
    }

    private DialogPacket getPlayableDialogPacket(String npcID) {
        DialogPacket returnPacket = null;
        if (this.dialogPackets.containsKey(this.globalTemporalPosition)) {
            Map<String, List<DialogPacket>> innnerPacketMap = this.dialogPackets.get(this.globalTemporalPosition);
            if (innnerPacketMap.containsKey(npcID)) {
                List<DialogPacket> npcOccs = innnerPacketMap.get(npcID);
                List<String> foundItems = this.gameSaver.getItems();
                List<String> readLines = this.gameSaver.getLines();
                for (DialogPacket packet : npcOccs) {
                    if (foundItems.containsAll(packet.requiredItems)) {
                        if (readLines.containsAll(packet.requiredLines)) {
                            if (packet.forbiddenLines == null) {
                                System.out.println("DialogController4: Es sind alle n\u00f6tigen Items und Zeilen vorhanden und keine Lines verboten");
                                returnPacket = packet;
                                continue;
                            }
                            if (DialogController4.inverseContains(packet.forbiddenLines, readLines)) {
                                System.out.println("DialogController4: Das Dialogpacket hat zwar verbotene Lines, unsere sind aber nicht dabei");
                                returnPacket = packet;
                                continue;
                            }
                            System.out.println("DialogController4: Das Dialogpacket ist verboten!");
                            continue;
                        }
                        System.out.println("DialogController4: Es sind alle n\u00f6tigen Items vorhanden, aber nicht alle Zeilen.");
                        continue;
                    }
                    System.out.println("DialogController4: Es sind nicht alle n\u00f6tigen Items gefunden worden");
                }
            } else {
                System.out.println("DialogController4: Zu diesem NPC gibt es im Moment kein Eintrag in der Story");
            }
        } else {
            System.out.println("DialogController4: FEHLER: Zu diesem Zeitpunkt gibt es keinen Eintrag");
        }
        if (returnPacket == null) {
            System.out.println("DialogController4: FEHLER: Obwohl erwartet gibt es kein DialogPacket was abgespielt werden, oder ist null");
        }
        return returnPacket;
    }

    public boolean isDialogPacketPlayable(String npcID) {
        boolean returnState = false;
        if (this.dialogPackets.containsKey(this.globalTemporalPosition)) {
            Map<String, List<DialogPacket>> innnerPacketMap = this.dialogPackets.get(this.globalTemporalPosition);
            if (innnerPacketMap.containsKey(npcID)) {
                List<DialogPacket> npcOccs = innnerPacketMap.get(npcID);
                List<String> foundItems = this.gameSaver.getItems();
                List<String> readLines = this.gameSaver.getLines();
                for (DialogPacket packet : npcOccs) {
                    if (foundItems.containsAll(packet.requiredItems)) {
                        if (readLines.containsAll(packet.requiredLines)) {
                            if (packet.forbiddenLines == null) {
                                System.out.println("DialogController4: Es sind alle n\u00f6tigen Items und Zeilen vorhanden und keine Lines verboten");
                                returnState = true;
                                continue;
                            }
                            if (DialogController4.inverseContains(packet.forbiddenLines, readLines)) {
                                System.out.println("DialogController4: Das Dialogpacket hat zwar verbotene Lines, unsere sind aber nicht dabei");
                                returnState = true;
                                continue;
                            }
                            System.out.println("DialogController4: Das Dialogpacket ist verboten!");
                            continue;
                        }
                        System.out.println("DialogController4: Es sind alle n\u00f6tigen Items vorhanden, aber nicht alle Zeilen.");
                        continue;
                    }
                    System.out.println("DialogController4: Es sind nicht alle n\u00f6tigen Items gefunden worden");
                }
                return returnState;
            }
            System.out.println("DialogController4: Zu diesem Spieler gibt es im Moment kein Eintrag in der Story");
            return false;
        }
        System.out.println("DialogController4: FEHLER: Zu diesem Zeitpunkt gibt es keinen Eintrag");
        return false;
    }

    private void updateButtons() {
        this.displayButtons[0].setOpacity(0.3f);
        if (this.oneButtonMode) {
            this.buttonCursor = 0;
            this.displayButtons[1].setOpacity(0.0f);
        } else {
            this.displayButtons[1].setOpacity(0.3f);
        }
        this.displayButtons[this.buttonCursor].setOpacity(1.0f);
    }

    public void input(String dir) {
        if (this.isWaitingForInput()) {
            switch (dir) {
                case "links": {
                    --this.buttonCursor;
                    if (this.buttonCursor < 0) {
                        this.buttonCursor = 0;
                    }
                    if (this.playingLastLine) break;
                    this.setReplyText();
                    break;
                }
                case "rechts": {
                    ++this.buttonCursor;
                    if (this.buttonCursor > 1) {
                        this.buttonCursor = 1;
                    }
                    if (this.playingLastLine) break;
                    this.setReplyText();
                    break;
                }
                case "enter": {
                    this.nextLine();
                    break;
                }
                default: {
                    System.out.println("DialogController4: Kein valider Input");
                }
            }
            this.updateButtons();
        } else {
            System.out.println("DialogController4: WARTET NICHT AUF INPUT");
        }
    }

    private void showWindow() {
        this.displayButtons[0].sichtbarSetzen(true);
        this.displayButtons[1].sichtbarSetzen(true);
        this.displayTextObject.sichtbarSetzen(true);
        this.displayResponseTextObject.sichtbarSetzen(true);
        this.displayDialogBackground.sichtbarSetzen(true);
    }

    private void hideWindow() {
        this.hideAllFaces();
        this.displayButtons[0].sichtbarSetzen(false);
        this.displayButtons[1].sichtbarSetzen(false);
        this.displayTextObject.sichtbarSetzen(false);
        this.displayResponseTextObject.sichtbarSetzen(false);
        this.displayDialogBackground.sichtbarSetzen(false);
    }

    private void setConvText(String text) {
        this.displayTextObject.inhaltSetzen(text);
        int width = (int)this.displayTextObject.getBreite();
        int posX_new = MAIN.x / 2 - width / 2;
        this.displayTextObject.positionSetzen(posX_new, this.textPosY);
    }

    private void setReplyText() {
        System.out.println("DialogController4: setReplyText() aufgerufen");
        this.displayResponseTextObject.sichtbarSetzen(false);
        DialogLine currentLine = this.dialogLines.get(this.currentDialogCode);
        if (currentLine.nextTime.equals("")) {
            if (this.isNextLineSelf(this.currentDialogCode)) {
                this.displayResponseTextObject.sichtbarSetzen(true);
            }
            if (this.lastLineSelf) {
                this.displayResponseTextObject.sichtbarSetzen(false);
            }
            if (this.playingLastLine) {
                this.displayResponseTextObject.sichtbarSetzen(false);
            }
            DialogLine nextLine = null;
            if (this.oneButtonMode) {
                this.buttonCursor = 0;
            }
            if (this.buttonCursor == 0) {
                nextLine = this.dialogLines.get(currentLine.wahl1);
            }
            if (this.buttonCursor == 1) {
                nextLine = this.dialogLines.get(currentLine.wahl2);
            }
            this.displayResponseTextObject.inhaltSetzen(nextLine.inhalt);
            int width = (int)this.displayResponseTextObject.getBreite();
            int posX_new = MAIN.x / 2 - width / 2;
            this.displayResponseTextObject.positionSetzen(posX_new, this.textPosY - 50);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public String getGlobalTemporalPosition() {
        return this.globalTemporalPosition;
    }

    public boolean isWaitingForInput() {
        return this.waitingForInput;
    }

    private void readJSON_DialogLines() {
        Gson gson = new Gson();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/Dialoge.json"));
            Type MapType = new TypeToken<Map<String, DialogLine>>(){}.getType();
            this.dialogLines = (Map)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println();
            System.out.println("\u001b[32mDialogController4: JSON(./Assets/Files/Dialoge.json)  erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogController4: Ein Fehler beim Lesen der Json Datei(./Assets/Files/Dialoge.json ). Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }

    private void readJSON_DialogPackets() {
        Gson gson = new Gson();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/DialogPackets.json"));
            Type MapType = new TypeToken<Map<String, Map<String, List<DialogPacket>>>>(){}.getType();
            this.dialogPackets = (Map)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println("\u001b[32mDialogController4: JSON(./Assets/Files/DialogPackets.json)  erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogController4: Ein Fehler beim Lesen der Json Datei(./Assets/Files/DialogPackets.json ). Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }

    public boolean isPlayingLastLine() {
        return this.playingLastLine;
    }

    private boolean isNextLineSelf(String code) {
        String w = this.dialogLines.get((Object)code).wahl1;
        DialogLine nextLine = this.dialogLines.get(w);
        if (nextLine == null) {
            System.out.println("DialogController4: FEHLER: Es die n\u00e4chste Line ist null. Das bedeutet meistens ein Fehler in der Json");
        }
        String nextName = nextLine.name;
        return nextName.equals("self");
    }

    public String getCurrentDialogCode() {
        return this.currentDialogCode;
    }

    public int getButtonCursor() {
        return this.buttonCursor;
    }

    public boolean isOneButtonMode() {
        return this.oneButtonMode;
    }

    public boolean isLastLineSelf() {
        return this.lastLineSelf;
    }

    public static <T> boolean inverseContains(List<T> a, List<T> b) {
        return a.stream().noneMatch(b::contains);
    }

    public class DialogPacket {
        ArrayList<String> requiredItems;
        ArrayList<String> requiredLines;
        ArrayList<String> forbiddenLines;
        String code;
    }

    public class DialogLine {
        String inhalt;
        String name;
        String wahl1;
        String wahl2;
        String nextTime;

        public String toString() {
            return "DialogLine{inhalt='" + this.inhalt + '\'' + ", name='" + this.name + '\'' + ", wahl1='" + this.wahl1 + '\'' + ", wahl2='" + this.wahl2 + '\'' + ", nextTime='" + this.nextTime + '\'' + '}';
        }
    }

    public class NpcPosition {
        private String name;
        private float posX;
        private float posY;
        private int houseN;

        public NpcPosition(String name, int x, int y, int hn) {
            this.name = name;
            this.posX = x;
            this.posY = y;
            this.houseN = hn;
        }

        public float getPosX() {
            return this.posX;
        }

        public float getPosY() {
            return this.posY;
        }

        public int getHouseN() {
            return this.houseN;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInHouse() {
            return this.houseN > -1;
        }
    }
}

